<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwbaggage="urn:WebWorks-Baggage-Schema"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwbaggage wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="wwsplits" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwtransform:common/files/filter.xsl" />
 <xsl:include href="wwtransform:common/files/format.xsl" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/files/filter.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/files/filter.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/files/format.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/files/format.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Skin Files URI -->
 <!--                -->
 <xsl:variable name="GlobalSkinFilesURI">
  <xsl:variable name="VarSkinFilesURI" select="concat('Skins/', wwprojext:GetFormatSetting('wwhelp-skin', 'Lobby_Blue'), '/Files')" />
  <xsl:choose>
   <xsl:when test="wwfilesystem:DirectoryExists(wwuri:AsFilePath(concat('wwformat:', $VarSkinFilesURI)))">
    <xsl:value-of select="$VarSkinFilesURI" />
   </xsl:when>

   <xsl:otherwise>
    <xsl:value-of select="'Skins/Lobby_Blue/Files'" />
   </xsl:otherwise>
  </xsl:choose>
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <xsl:variable name="VarIgnore1Start" select="wwprogress:Start(1)" />

   <!-- Merge required? -->
   <!--                 -->
   <xsl:if test="count($GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group) &gt; 1">
    <xsl:variable name="VarIgnore2Start" select="wwprogress:Start(2)" />

     <!-- Format files -->
     <!--              -->
     <xsl:variable name="VarFormatFilesAsXML">
      <xsl:call-template name="Files-Format-GetRelativeFiles">
       <xsl:with-param name="ParamRelativeURIPath" select="'Files'" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarFormatFiles" select="msxsl:node-set($VarFormatFilesAsXML)" />
     <xsl:call-template name="CopyFilesToTargetOutputDirectory">
      <xsl:with-param name="ParamReferenceURI" select="'wwformat:Files/'" />
      <xsl:with-param name="ParamFiles" select="$VarFormatFiles/wwfiles:Files/wwfiles:File[not(starts-with(@path, 'wwhdata'))]" />
     </xsl:call-template>

     <!-- Skin files -->
     <!--            -->
     <xsl:variable name="VarSkinFilesAsXML">
      <xsl:call-template name="Files-Format-GetRelativeFiles">
       <xsl:with-param name="ParamRelativeURIPath" select="$GlobalSkinFilesURI" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarSkinFiles" select="msxsl:node-set($VarSkinFilesAsXML)" />
     <xsl:call-template name="CopyFilesToTargetOutputDirectory">
      <xsl:with-param name="ParamReferenceURI" select="concat('wwformat:', $GlobalSkinFilesURI, '/')" />
      <xsl:with-param name="ParamFiles" select="$VarSkinFiles/wwfiles:Files/wwfiles:File" />
     </xsl:call-template>

    <xsl:variable name="VarIgnore2End" select="wwprogress:End()" />
   </xsl:if>

   <xsl:variable name="VarIgnore1End" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="CopyFilesToTargetOutputDirectory">
  <xsl:param name="ParamReferenceURI" />
  <xsl:param name="ParamFiles" />

  <xsl:variable name="VarProgressCopyFilesStart" select="wwprogress:Start(count($ParamFiles))" />

  <xsl:for-each select="$ParamFiles">
   <xsl:variable name="VarFile" select="." />

   <xsl:variable name="VarProgressCopyFileStart" select="wwprogress:Start(1)" />

   <xsl:variable name="VarSourceURI" select="wwuri:MakeAbsolute($ParamReferenceURI, $VarFile/@path)" />
   <xsl:variable name="VarSourcePath" select="wwuri:AsFilePath($VarSourceURI)" />
   <xsl:variable name="VarDestinationPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarFile/@path)" />

   <!-- Allow? -->
   <!--        -->
   <xsl:variable name="VarAllow">
    <xsl:call-template name="Files-Filter-Allow">
     <xsl:with-param name="ParamPath" select="$VarSourcePath" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:if test="$VarAllow = 'true'">
    <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarDestinationPath, '', '', '', concat($GlobalActionChecksum, ':', $VarSourcePath))" />
    <xsl:if test="not($VarUpToDate)">
     <xsl:variable name="VarIgnore" select="wwfilesystem:CopyFile($VarSourcePath, $VarDestinationPath)" />
    </xsl:if>

    <wwfiles:File path="{$VarDestinationPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarDestinationPath)}" projectchecksum="" groupID="" documentID="" actionchecksum="{concat($GlobalActionChecksum, ':', $VarSourcePath)}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
     <wwfiles:Depends path="{$VarSourcePath}" checksum="{wwfilesystem:GetChecksum($VarSourcePath)}" groupID="" documentID="" />
    </wwfiles:File>
   </xsl:if>

   <xsl:variable name="VarProgressCopyFileEnd" select="wwprogress:End()" />
  </xsl:for-each>

  <xsl:variable name="VarProgressCopyFilesEnd" select="wwprogress:End()" />
 </xsl:template>
</xsl:stylesheet>
